set TheResultsFile to (path to home folder from user domain as text) & "%@"
-- set TheResultsFile to (path to home folder from user domain as text) & "Test.plist"

set LF to ASCII character 10
set quoteMark to "\""

on encode_XML(this_text)
	--  set search_strings to {"&amp;", "&quot;", "&#39;", "<", ">"}
	--  set replacement_strings to {"&", "\"", "'", "<", ">"}
	set search_strings to {"&", "\"", "'", "<", ">"}
	set replacement_strings to {"&amp;", "&quot;", "&#39;", "&lt;", "&gt;"}
	repeat with i from 1 to (count of search_strings)
		set search_string to item i of search_strings
		set replacement_string to item i of replacement_strings
		if this_text contains search_string then
			set AppleScript's text item delimiters to search_string
			set the item_list to every text item of this_text
			set AppleScript's text item delimiters to replacement_string
			set this_text to the item_list as string
			set AppleScript's text item delimiters to ""
		end if
	end repeat
	return this_text
end encode_XML

on trim_line(this_text, trim_chars, trim_indicator)
	-- 0 = beginning, 1 = end, 2 = both
	set x to the length of the trim_chars
	-- TRIM BEGINNING
	if the trim_indicator is in {0, 2} then
		repeat while this_text begins with the trim_chars
			try
				set this_text to characters (x + 1) thru -1 of this_text as string
			on error
				-- the text contains nothing but the trim characters
				return ""
			end try
		end repeat
	end if
	-- TRIM ENDING
	if the trim_indicator is in {1, 2} then
		repeat while this_text ends with the trim_chars
			try
				set this_text to characters 1 thru -(x + 1) of this_text as string
			on error
				-- the text contains nothing but the trim characters
				return ""
			end try
		end repeat
	end if
	return this_text
end trim_line


tell application "iTunes.app"
	activate
end tell

tell application "System Events"
	tell process "iTunes.app"
		try
			set FileMenu to (get name of menu 3 of menu bar 1)
			set FileMenuItems to (get name of every menu item of menu 3 of menu bar 1)
		on error
			set FileMenu to "File"
			set FileMenuItems to {"New Playlist", "New Playlist from Selection", "New Smart Playlist", "New Folder", "missing value", "Add to Library", "Close window", "missing value", "Import", "Export", "Export Library", "Backup to Disc", "missing value", "Get Info", "My Rating", "Edit Smart Playlist", "Show in Finder", "Show Current Song", "missing value", "Burn Playlist to Disc"}
		end try
		
		repeat with an_item in FileMenuItems
			--	display dialog (an_item)
		end repeat
		--get name of menu item 20 of menu 3 of menu bar 1
		--get name of every menu item of menu 3 of menu bar 1
		--click the menu item "Burn Playlist to Disc" of the menu "File" of menu bar 1
		
		
		try
			set results_fd to open for access file TheResultsFile with write permission
		on error
			close access file TheResultsFile
			set results_fd to open for access file TheResultsFile with write permission
		end try
		
		set eof of results_fd to 0
		write "<?xml version=" & quoteMark & "1.0" & quoteMark & " encoding=" & quoteMark & "UTF-8" & quoteMark & "?>" & LF as class utf8 to results_fd
		write "<!DOCTYPE plist PUBLIC " & quoteMark & "-//Apple Computer//DTD PLIST 1.0//EN" & quoteMark & " " & quoteMark & "http://www.apple.com/DTDs/PropertyList-1.0.dtd" & quoteMark & ">" & LF as class utf8 to results_fd
		write "<plist version=" & quoteMark & "1.0" & quoteMark & ">" & LF as class utf8 to results_fd
		write "<dict>" & LF as class utf8 to results_fd
		write tab & "<key>filemenu</key>" & LF as class utf8 to results_fd
		write tab & "<string>" & (get FileMenu as string) & "</string>" & LF as class utf8 to results_fd
		write tab & "<key>items</key>" & LF as class utf8 to results_fd
		write tab & "<array>" & LF as class utf8 to results_fd
		repeat with an_item in FileMenuItems
			set TheMenuItemString to (get an_item as string)
			set TheItemString to (get my trim_line(TheMenuItemString, "", 2) as string)
			write tab & "<string>" & TheMenuItemString & "</string>" & LF as class utf8 to results_fd
		end repeat
		write tab & "</array>" & LF as class utf8 to results_fd
		
		close access results_fd
		
	end tell
end tell

tell application "iTunes.app"
	
	try
		set results_fd to open for access file TheResultsFile with write permission
	on error
		close access file TheResultsFile
		set results_fd to open for access file TheResultsFile with write permission
	end try
	write tab & "<key>playlists</key>" & LF as class utf8 to results_fd starting at eof
	write tab & "<array>" & LF as class utf8 to results_fd
	
	repeat with i from 1 to the count of playlists
		set TheSource to playlist i
		set ThePlaylistName to my encode_XML((get name of TheSource as string))
		write tab & "<string>" & ThePlaylistName & "</string>" & LF as class utf8 to results_fd
	end repeat
	write tab & "</array>" & LF as class utf8 to results_fd
	
	write "</dict>" & LF as class utf8 to results_fd
	write "</plist>" & LF as class utf8 to results_fd
	
	close access results_fd
	
	quit
end tell


